unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TViewer_Form = class(TForm)
    RichEd: TRichEdit;
    BT_ViewClose: TButton;
    procedure BT_ViewCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var Viewer_Form: TViewer_Form;
    FileToView, CaptionToShow: STRING;

implementation

USES Unit1;

{$R *.DFM}

procedure TViewer_Form.BT_ViewCloseClick(Sender: TObject);
begin
Viewer_Form.Close;
end;


procedure TViewer_Form.FormClose(Sender: TObject; var Action: TCloseAction);
begin
RichEd.Lines.Clear;
Viewer_Form.Caption:='';
BT_ViewClose.Caption:='';
Unit1.Haupt_Form.Enabled:=TRUE;
end;


procedure TViewer_Form.FormShow(Sender: TObject);
begin
IF (Language = 1)
 THEN BT_ViewClose.Caption:='&Close'
 ELSE BT_ViewClose.Caption:='&Schlieen';
Viewer_Form.Caption:=CaptionToShow;
RichEd.Lines.Clear;
IF (FileExists(FileToView))
 THEN RichEd.Lines.LoadFromFile (FileToView)
 ELSE
  IF (Language = 1)
   THEN RichEd.Lines.Add ('Could not find file: ' + CHR(13) + FileToView)
   ELSE RichEd.Lines.Add ('Konnte Datei nicht finden: ' + CHR(13) + FileToView);
ActiveControl:=RichEd;
end;



procedure TViewer_Form.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
IF (Key=VK_ESCAPE) THEN Viewer_Form.Close;
end;

end.
